unit Ora;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics,
  Controls, DsgnIntf, Dialogs, Math ;

 type

 TEbresztesEvent = procedure (Sender: TObject) of object;

 TOra = class(TCustomControl)
  private
    FEOra  : Byte;
    FEPerc : Byte;
    FIdozito : Integer;
    FMukodik : Boolean;
    FEbreszteni : Boolean;
    FOnEbresztes : TEbresztesEvent;
    FColor: TColor;
    procedure SetColor(Color: TColor);
    procedure SetMukodik(Run: Boolean);
    procedure SetEOra(Ora24 : byte);
    procedure SetEPerc(Perc : byte);
  protected
    procedure Paint; override;
    procedure WMIdozito(var Message: TMessage); message WM_Timer;
    procedure WMDestroy(var Message: TMessage); message wm_Destroy;
    procedure Atmeretezes(Sender : TObject);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Ebreszteni : Boolean read FEbreszteni write FEbreszteni;
    property Mukodik: Boolean read FMukodik write SetMukodik;
    property Szin : TColor read FColor write SetColor;
    Property EbresztOra : Byte read FEOra write SetEOra;
    Property EbresztPerc : Byte read FEPerc write SetEPerc;
    property OnEbresztes: TEbresztesEvent read FOnEbresztes write FOnEbresztes;
  end;

  TOraEditor = class(TComponentEditor)
    procedure Edit; override;
  end;

  TSzinProperty = class(TColorProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;


procedure Register;

implementation
{$R  Ora.res}

procedure Register;
begin
  RegisterComponents('Samples', [TOra]);
  RegisterComponentEditor(TOra, TOraEditor);
  RegisterPropertyEditor(TypeInfo(TColor), TOra, 'Szin',
                         TSzinProperty);
end;

{ --- TOra --- }

constructor TOra.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 100;
  height := 100;
  FIdozito := 1;
  FColor := clAqua;
  onResize:=Atmeretezes;
end;

procedure TOra.wmDestroy(var Message: TMessage);
begin
  KillTimer(Handle, FIdozito);
  FIdozito := 0;
 inherited;
end;

procedure TOra.Paint;
begin
  Canvas.Brush.Color := FColor;
  Canvas.Pen.Color := cLBlack;
  Canvas.RoundRect(0, 0, width, height,width div 3,height div 3);
  inherited Paint;
end;

procedure TOra.SetMukodik(Run: Boolean);
begin
  if Run then begin
    SetTimer(Handle, FIdozito, 50, nil);
    FMukodik := True;
  end else begin
    KillTimer(Handle, FIdozito);
    FMukodik := False;
  end;
end;

procedure TOra.SetColor(Color: TColor);
begin
  FColor := Color;
  InvalidateRect(Handle, nil, True);
end;

procedure TOra.SetEOra(Ora24: Byte);
begin
  if Ora24 in [0..23] then FEOra:=Ora24;
end;

procedure TOra.SetEPerc(Perc: Byte);
begin
  if Perc in [0..59] then FEPerc:=Perc;
end;


procedure TOra.WMIdozito(var Message: TMessage);
var
  S: string;
  Hs,Ms,Ss,MSs : word;
begin
  S := FormatDateTime('hh:mm:ss',Time);
  DecodeTime(Time, Hs, Ms, Ss ,MSs);
  Canvas.Font.Size:=min(width, Height) div 5;
  Canvas.TextOut((Width div 2) - (Canvas.TextWidth(S) div 2),
                 (Height div 2)- (Canvas.TextHeight(S) div 2),S);

  if Ebreszteni and (Hs=FEOra) and (Ms=FEperc) then
   begin
      FEbreszteni:=False;
      if Assigned(FOnEbresztes) then FOnEbresztes(Self);
   end;

end;

procedure TOra.Atmeretezes(Sender:TObject);
begin
  SysUtils.beep;
  repaint;
end;



{ --- TOraEditor --- }

procedure TOraEditor.Edit;
begin
  MessageDlg('ra ptelem', mtInformation, [mbOK],0);
end;

{ --- TSzinProperty --- }

function TSzinProperty.GetAttributes;
begin
  Result := [paMultiSelect, paValueList, paDialog];
end;


procedure TSzinProperty.Edit;
var
  S: String;
begin
  S := '';
  InputQuery('Sznmegads', 'Krem a sznt', S);
  SetValue(S);
end;

end.
